/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.animation;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

@Environment(value=EnvType.CLIENT)
public class CuckooClockAnimationBehaviour
extends AnimationBehaviour<CuckooClockBlockEntity> {
    public LerpedFloat hourHand = LerpedFloat.angular();
    public LerpedFloat minuteHand = LerpedFloat.angular();

    public CuckooClockAnimationBehaviour(CuckooClockBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAnimation() {
        block13: {
            CuckooClockBlockEntity.Animation animationType;
            class_1937 world;
            block11: {
                block12: {
                    if (((CuckooClockBlockEntity)this.blockEntity).getSpeed() == 0.0f) {
                        return;
                    }
                    world = ((CuckooClockBlockEntity)this.blockEntity).method_10997();
                    int dayTime = (int)(world.method_8532() % 24000L);
                    int hours = (dayTime / 1000 + 6) % 24;
                    int minutes = dayTime % 1000 * 60 / 1000;
                    this.moveHands(hours, minutes);
                    animationType = ((CuckooClockBlockEntity)this.blockEntity).animationType;
                    if (animationType != CuckooClockBlockEntity.Animation.NONE) break block11;
                    if (AnimationTickHolder.getTicks() % 32 != 0) break block12;
                    this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 2.0f);
                    break block13;
                }
                if (AnimationTickHolder.getTicks() % 16 != 0) break block13;
                this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 1.5f);
                break block13;
            }
            boolean isSurprise = animationType == CuckooClockBlockEntity.Animation.SURPRISE;
            float value = ((CuckooClockBlockEntity)this.blockEntity).getAndIncrementProgress();
            if (value > 100.0f) {
                animationType = null;
            }
            if (value == 1.0f) {
                this.playSound((class_3414)class_3417.field_14725.comp_349(), 2.0f, 0.5f);
            }
            if (value == 21.0f) {
                this.playSound((class_3414)class_3417.field_14725.comp_349(), 2.0f, 0.793701f);
            }
            if (value > 30.0f && isSurprise) {
                class_243 pos = VecHelper.offsetRandomly(VecHelper.getCenterOf((class_2382)((CuckooClockBlockEntity)this.blockEntity).method_11016()), world.field_9229, 0.5f);
                world.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            }
            if (value == 40.0f && isSurprise) {
                this.playSound(class_3417.field_15079, 1.0f, 1.0f);
            }
            int step = isSurprise ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                if (value == (float)(phase - step / 3)) {
                    this.playSound(class_3417.field_14982, 0.0625f, 2.0f);
                }
                if (value == (float)phase) {
                    if (animationType == CuckooClockBlockEntity.Animation.PIG) {
                        this.playSound(class_3417.field_14615, 0.25f, 1.0f);
                    } else {
                        this.playSound(class_3417.field_15192, 0.25f, 3.0f);
                    }
                }
                if (value != (float)(phase + step / 3)) continue;
                this.playSound(class_3417.field_14823, 0.0625f, 2.0f);
            }
        }
    }

    private void moveHands(int hours, int minutes) {
        float hourTarget = 30 * (hours % 12);
        float minuteTarget = 6 * minutes;
        this.hourHand.chase(hourTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.minuteHand.chase(minuteTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.hourHand.tickChaser();
        this.minuteHand.tickChaser();
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        class_243 vec = VecHelper.getCenterOf((class_2382)((CuckooClockBlockEntity)this.blockEntity).method_11016());
        ((CuckooClockBlockEntity)this.blockEntity).method_10997().method_8486(vec.field_1352, vec.field_1351, vec.field_1350, sound, class_3419.field_15245, volume, pitch, false);
    }
}

